/*
 * Decompiled with CFR 0.152.
 */
package notryken.effecttimerplus.util;

import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1074;
import net.minecraft.class_1293;
import notryken.effecttimerplus.EffectTimerPlus;

public class MiscUtil {
    public static final IntUnaryOperator toAlpha = value -> value >> 24 & 0xFF;
    public static final IntUnaryOperator toRed = value -> value >> 16 & 0xFF;
    public static final IntUnaryOperator toGreen = value -> value >> 8 & 0xFF;
    public static final IntUnaryOperator toBlue = value -> value & 0xFF;
    public static final IntUnaryOperator fromAlpha = value -> value * 0x1000000;
    public static final IntUnaryOperator fromRed = value -> value * 65536;
    public static final IntUnaryOperator fromGreen = value -> value * 256;
    public static final IntUnaryOperator fromBlue = value -> value;
    public static final IntBinaryOperator withAlpha = (value, alpha) -> value - fromAlpha.applyAsInt(toAlpha.applyAsInt(value)) + alpha;
    public static final IntBinaryOperator withRed = (value, red) -> value - fromRed.applyAsInt(toRed.applyAsInt(value)) + red;
    public static final IntBinaryOperator withGreen = (value, green) -> value - fromGreen.applyAsInt(toGreen.applyAsInt(value)) + green;
    public static final IntBinaryOperator withBlue = (value, blue) -> value - fromBlue.applyAsInt(toBlue.applyAsInt(value)) + blue;

    public static int getTimerColor(class_1293 effectInstance) {
        int color = EffectTimerPlus.config().getTimerColor();
        if (EffectTimerPlus.config().timerWarnEnabled && effectInstance.method_5584() != -1 && effectInstance.method_5584() / 20 <= EffectTimerPlus.config().getTimerWarnTime() && (!EffectTimerPlus.config().timerFlashEnabled || effectInstance.method_5584() % 20 >= 10)) {
            color = EffectTimerPlus.config().getTimerWarnColor();
        }
        return color;
    }

    public static String getAmplifierAsString(int amplifier) {
        int value = amplifier + 1;
        if (value > 1) {
            String key = String.format("enchantment.level.%d", value);
            if (class_1074.method_4663((String)key)) {
                return class_1074.method_4662((String)key, (Object[])new Object[0]);
            }
            return String.valueOf(value);
        }
        return "";
    }

    public static String getDurationAsString(int durationTicks) {
        if (durationTicks == -1) {
            return "\u221e";
        }
        int seconds = durationTicks / 20;
        if (seconds >= 360000) {
            return "\u221e";
        }
        if (seconds >= 3600) {
            return seconds / 3600 + "h";
        }
        if (seconds >= 60) {
            return seconds / 60 + "m";
        }
        return String.valueOf(seconds);
    }

    public static int getTextOffsetX(int locIndex, int labelWidth) {
        return switch (locIndex) {
            case 0, 6, 7 -> 3;
            case 1, 5 -> 13 - labelWidth / 2;
            case 2, 3, 4 -> 22 - labelWidth;
            default -> throw new IllegalStateException("Unexpected positional index outside of allowed range (0-7): " + locIndex);
        };
    }

    public static int getTextOffsetY(int locIndex) {
        return switch (locIndex) {
            case 0, 1, 2 -> 3;
            case 3, 7 -> 9;
            case 4, 5, 6 -> 14;
            default -> throw new IllegalStateException("Unexpected positional index outside of allowed range (0-7): " + locIndex);
        };
    }
}

